﻿///
/// ファイル（格納アイテム）プロパティの集合と情報を管理するクラスのヘッダファイル。
/// Internal: 非公開
///

#if       !defined(INCLUDED_SZ_FILE_PROPERTY_INFO)
#define            INCLUDED_SZ_FILE_PROPERTY_INFO

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#include  <7zip/PropID.h>

SZ_NS_BEG(szpp)

/// <summary>
/// 7-Zip の格納ファイルプロパティと StoredItem のプロパティをマッピングするためのクラス。
/// </summary>
/// <notes>
/// クライアントは本クラスの存在を意識する必要はない。ArchiveEnumerator が格納ファイル情報を取得するときに、
/// 特定のプロパティにアクセスできるかどうかを把握する必要があるので、もっぱらそのために用意されているクラスである。
/// </notes>
class SZ_SPEC FilePropertyInfo : boost::noncopyable
{
public:

  FilePropertyInfo();
  ~FilePropertyInfo();

  void AddProperty(PROPID propID);

  index_t GetNumberOfProperties() const { return idList.size(); }
  PROPID  GetPropertyID(index_t index) const { return idList[index]; }

  PROPID HasPath() const { return hasPath ? kpidPath : 0; }
  PROPID HasActualSize() const { return hasActualSize ? kpidSize : 0; }
  PROPID HasStoredSize() const { return hasStoredSize ? kpidPackSize : 0; }
  PROPID HasAttributes() const { return hasAttributes ? kpidAttrib : 0; }
  PROPID HasCreated() const { return hasCreated ? kpidCTime : 0; }
  PROPID HasAccessed() const { return hasAccessed ? kpidATime : 0; }
  PROPID HasModified() const { return hasModified ? kpidMTime : 0; }

  PROPID HasIsDir() const { return hasIsDir ? kpidIsDir : 0; }

private:

  bool hasPath;
  bool hasActualSize;
  bool hasStoredSize;
  bool hasAttributes;
  bool hasCreated;
  bool hasAccessed;
  bool hasModified;

  bool hasIsDir;

  std::vector<PROPID> idList;
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_FILE_PROPERTY_INFO)
